﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Xml.Xsl;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using Gemini.Core.BL.Interface.BO;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private APIMobileBL _APIMobile = null;
        public APIMobileBL APIMobile
        {
            get
            {
                if (_APIMobile == null)
                {
                    _APIMobile = new APIMobileBL(this);
                }

                return _APIMobile;
            }
        }

        public class APIMobileBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public APIMobileBL(ZSBELearning BL) : base(BL) { }

            /// <summary>
            /// Zwraca dane uzytkownika podczas logowania: userslogin
            /// UWAGA: ID to jest UserID ze studenta albo Instruktora !!!
            /// </summary>
            /// <param name="User"></param>
            /// <returns></returns>
            public GUsersView GetGUser(IUserGroup User)
            {
                if ((BL.Dictionary.GroupType)User.GroupEnumID == Dictionary.GroupType.Student)
                {
                    BO.Student _student = BLP.Student.RestoreByUser(User);
                    if (_student != null)
                    {
                        GUsersView _GUser = new GUsersView();
                        _GUser.class_id = _student.ClassID.Value;
                        _GUser.class_order = _student.IndexNr.Value;
                        _GUser.email = _student.Email;
                        _GUser.gender = _student.Sex.Value ? 1 : 0;
                        _GUser.id = _student.UserID.Value;
                        _GUser.name = _student.Forename;
                        _GUser.role = 1;
                        _GUser.school_id = BLP.Class.RestoreById(_student.ClassID).SchoolID.Value;
                        _GUser.score = 0;
                        _GUser.surname = _student.Surename;
                        _GUser.title = string.Empty;
                        _GUser.created = GUtils.DateToUnixTimestamp(_student.Extension.CreateDate.Value);
                        _GUser.modified = GUtils.DateToUnixTimestamp(_student.Extension.EditDate.Value);
                        return _GUser;
                    }
                }
                else if ((BL.Dictionary.GroupType)User.GroupEnumID == Dictionary.GroupType.Instructor)
                {
                    BO.Instructor _instructor = BLP.Instructor.RestoreByUser(User);
                    if (_instructor != null)
                    {
                        GUsersView _GUser = new GUsersView();
                        _GUser.email = _instructor.Email;
                        _GUser.id = _instructor.UserID.Value;
                        _GUser.name = _instructor.Forename;
                        _GUser.phone = _instructor.Tel;
                        _GUser.role = 2;
                        _GUser.school_id = _instructor.SchoolID.Value;
                        _GUser.score = 0;
                        _GUser.surname = _instructor.Surename;
                        _GUser.title = _instructor.Title;
                        _GUser.created = GUtils.DateToUnixTimestamp(_instructor.Extension.CreateDate.Value);
                        _GUser.modified = GUtils.DateToUnixTimestamp(_instructor.Extension.EditDate.Value);
                        return _GUser;
                    }
                }
                else
                {
                }
                return null;
            }

            /// <summary>
            /// Zwraca liste szkol dla zapytania: schoolsindex
            /// </summary>
            /// <returns></returns>
            public List<GSchoolIndex> GetGSchoolsIndexList()
            {
                return BLP.School.Restore().Select(x => new GSchoolIndex() { name = x.Name, school_id = x.ID.Value, modified = GUtils.DateToUnixTimestamp(x.Extension.EditDate.Value) }).ToList();
            }

            /// <summary>
            /// Zwraca szczegolowe dane szkoly dla zapytania: schoolsview
            /// </summary>
            /// <param name="SchoolID"></param>
            /// <returns></returns>
            public GSchoolView GetGSchoolView(int SchoolID)
            {
                if (SchoolID > 0)
                {
                    BO.School _school = BLP.School.Restore(SchoolID);
                    if (_school != null)
                    {
                        GSchoolView _GSchoolView = new GSchoolView();
                        _GSchoolView.address1 = _school.AddressLine1;
                        _GSchoolView.address2 = _school.AddressLine2;
                        _GSchoolView.city = _school.Town;
                        _GSchoolView.email = _school.Email;
                        _GSchoolView.fax = _school.Fax;
                        _GSchoolView.name = _school.Name;
                        _GSchoolView.phone = _school.Tel;
                        _GSchoolView.postal = _school.PostCode;
                        _GSchoolView.school_id = _school.ID.Value;
                        _GSchoolView.modified = GUtils.DateToUnixTimestamp(_school.Extension.EditDate.Value);
                        return _GSchoolView;
                    }
                }
                return null;
            }

            /// <summary>
            /// Metoda zwraca liste userow (studentow) dla zapytania API usersindex dla zadanej szkoly, nauczyciela lub klasy
            /// </summary>
            /// <returns></returns>
            public List<GUsersIndex> GetGUsersIndexList(long SchoolID, long InstructoriID, long ClassID)
            {
                long? _SchoolID = null;
                long? _InstructorID = null;
                long? _ClassID = null;

                if (SchoolID > 0) { _SchoolID = SchoolID; }
                if (InstructoriID > 0) 
                {
                    BO.Instructor _instructor = BLP.Instructor.Restore(new BO.Instructor.Search() { UserID = InstructoriID }).FirstOrDefault();
                    if (_instructor != null)
                    {
                        _InstructorID = _instructor.ID.Value;
                    }
                }
                if (ClassID > 0) { _ClassID = ClassID; }

                return BLP.Student.Restore(new BO.Student.Search() { SchoolID = _SchoolID, InstructorID = _InstructorID, ClassID = _ClassID }).Select(x => new GUsersIndex() { email = x.Email, id = x.UserID.Value, classid = x.ClassID.Value, index_nr = x.IndexNr.Value, name = x.Forename, surname = x.Surename, gender = x.Sex == true ? "kobieta" : "mężczyzna", modified = GUtils.DateToUnixTimestamp(x.Extension.EditDate.Value) }).ToList();                
            }

            /// <summary>
            /// Metoda zwraca liste klas dla zapytania API usersindex dla zadanej szkoly lub nauczyciela
            /// </summary>
            /// <returns></returns>
            public List<GClassIndex> GetGClassIndexList(long SchoolID, long InstructoriID)
            {
                long? _SchoolID = null;
                long? _InstructorID = null;

                if (SchoolID > 0) { _SchoolID = SchoolID; }
                if (InstructoriID > 0) 
                {
                    BO.Instructor _instructor = BLP.Instructor.Restore(new BO.Instructor.Search() { UserID = InstructoriID }).FirstOrDefault();
                    if (_instructor != null)
                    {
                        _InstructorID = _instructor.ID.Value;
                    }
                }

                Gemini.Utility.Collections.AutoDictionary<long?, BO.SchoolYear> _dictionarySchoolYear = new Gemini.Utility.Collections.AutoDictionary<long?, BO.SchoolYear>(BLP.SchoolYear.Restore);

                return BLP.Class.Restore(new BO.Class.Search() { SchoolID = _SchoolID, InstructorID = _InstructorID }).Select(x => new GClassIndex() { id = x.ID.Value, name = x.Name, name2 = _dictionarySchoolYear.Restore(x.SchoolYearID).Name, modified = GUtils.DateToUnixTimestamp(x.Extension.EditDate.Value) }).ToList();
            }

            /// <summary>
            /// Metoda zwraca dane usera dla metody API usersview
            /// </summary>
            /// <param name="Email"></param>
            /// <returns></returns>
            public GUsersView GetGUser(string Email)
            {
                PI.FM.N001.Account.BL.BO.View.User _user = BLP.RBL.Account.User.View.RestoreByLoginOrEmail(Email);
                if (_user != null)
                {
                    return GetGUser(_user);
                }
                return null;
            }

            public bool SchoolExists(int SchoolId)
            {
                return BLP.School.Restore(SchoolId) != null;
            }

            /// <summary>
            /// Metoda zwraca strukture drzewa kompetencji (kopetencje, kompetencje skladowe, kursy)
            /// dla metody API competencesindex
            /// SuggestedContextID, SuggestedCourseID - kontynuacja nauki
            /// </summary>
            /// <param name="SuggestedContextID"></param>
            /// <param name="SuggestedCourseID"></param>
            /// <returns></returns>
            public List<GCompetencesIndex> GetGCompetencesIndexList(Gemini.Core.BL.Interface.IUserGroup User, out long SuggestedContextID, out long SuggestedCourseID)
            {
                SuggestedContextID = 0;
                SuggestedCourseID = 0;

                BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                if (_group == Dictionary.GroupType.Student)
                {
                    PI.ZB.N1200.ELearning.BL.BO.Student _student = BLP.Student.RestoreByUser(User);
                    if (_student != null)
                    {
                        BL.ZSBELearning.ContextParam _contextParam = BLP.Utility.GetValidContext(_student);
                        if (_contextParam != null && _contextParam.Course != null)
                        {
                            SuggestedContextID = _contextParam.ContextObjectID;
                            SuggestedCourseID = _contextParam.Course.ID.Value;
                        }
                    }
                }

                List<GCompetencesIndex> _result = new List<GCompetencesIndex>();
                List<BO.Competence> _listCompetence = BLP.Competence.Restore();

                BO.CompetencePart.Search _competencePartSearch = new BO.CompetencePart.Search();
                _competencePartSearch.IsActive = true;
                _competencePartSearch.IsValid = true;

                List<BO.CompetencePart> _listCompetencePart = BLP.CompetencePart.Restore(_competencePartSearch);

                int _currentID = 0;

                #region Start Course
                long? _startKnowledgeTestCourseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn);
                long? _startAdvancedTestCourseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);
                long? _endKnowledgeTestCourseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.EndKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn);
                long? _endAdvancedTestCourseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.EndAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);

                if (_startKnowledgeTestCourseID.HasValue)
                {
                    _currentID++;
                    GM.N610.ELearning.BL.BO.Course _course = BLP.BLELearning.Course.Restore(_startKnowledgeTestCourseID);
                    GCompetencesIndex _GCompetencesIndex = new GCompetencesIndex();
                    _GCompetencesIndex.id = _currentID;
                    _GCompetencesIndex.context_id = BL.Dictionary.Config.Tests.StartKnowledgeTest.ContextObjectID;
                    _GCompetencesIndex.course_id = _course.ID.Value;
                    _GCompetencesIndex.name = _course.Title;
                    _GCompetencesIndex.parent_id = 0;
                    _GCompetencesIndex.score = null;
                    _GCompetencesIndex.state = 2;
                    _GCompetencesIndex.type = 4;
                    _result.Add(_GCompetencesIndex);
                }
                if (_startAdvancedTestCourseID.HasValue)
                {
                    _currentID++;
                    GM.N610.ELearning.BL.BO.Course _course = BLP.BLELearning.Course.Restore(_startAdvancedTestCourseID);
                    GCompetencesIndex _GCompetencesIndex = new GCompetencesIndex();
                    _GCompetencesIndex.id = _currentID;
                    _GCompetencesIndex.context_id = BL.Dictionary.Config.Tests.StartAdvancedTest.ContextObjectID;
                    _GCompetencesIndex.course_id = _course.ID.Value;
                    _GCompetencesIndex.name = _course.Title;
                    _GCompetencesIndex.parent_id = 0;
                    _GCompetencesIndex.score = null;
                    _GCompetencesIndex.state = 2;
                    _GCompetencesIndex.type = 4;
                    _result.Add(_GCompetencesIndex);
                }
                #endregion

                #region Drzewko
                int _lastCompetenceID = 0;
                int _lastCompetencePartID = 0;
                foreach (BO.Competence _loopCompetence in _listCompetence)
                {
                    if (_loopCompetence.IsActive != true)
                    {
                        continue;
                    }

                    _currentID++;
                    GCompetencesIndex _GCompetencesIndex = new GCompetencesIndex();
                    _GCompetencesIndex.id = _currentID;
                    _GCompetencesIndex.name = _loopCompetence.Name;
                    _GCompetencesIndex.parent_id = 0;
                    _GCompetencesIndex.score = null;
                    _GCompetencesIndex.state = 2;
                    _GCompetencesIndex.type = 0;
                    _result.Add(_GCompetencesIndex);

                    _lastCompetenceID = _currentID;
                    foreach (BO.CompetencePart _loopCompetencePart in _listCompetencePart.Where(x => x.CompetenceID == _loopCompetence.ID).ToList())
                    {
                        if (!(_loopCompetencePart.IsActive == true && _loopCompetencePart.IsValid == true))
                        {
                            continue;
                        }

                        _currentID++;
                        _GCompetencesIndex = new GCompetencesIndex();
                        _GCompetencesIndex.id = _currentID;
                        _GCompetencesIndex.name = _loopCompetencePart.Name;
                        _GCompetencesIndex.parent_id = _lastCompetenceID;
                        _GCompetencesIndex.score = null;
                        _GCompetencesIndex.state = 2;
                        _GCompetencesIndex.type = 0;
                        _result.Add(_GCompetencesIndex);

                        _lastCompetencePartID = _currentID;

                        GM.N610.ELearning.BL.BO.Course _course = BLP.BLELearning.Course.Restore(_loopCompetencePart.CompetenceTheoryID);
                        if (_course != null)
                        {
                            // Teoria
                            _currentID++;
                            _GCompetencesIndex = new GCompetencesIndex();
                            _GCompetencesIndex.context_id = _loopCompetencePart.ID.Value;
                            _GCompetencesIndex.course_id = _course.ID.Value;
                            _GCompetencesIndex.id = _currentID;
                            _GCompetencesIndex.name = _course.Title;
                            _GCompetencesIndex.parent_id = _lastCompetencePartID;
                            _GCompetencesIndex.score = null;
                            _GCompetencesIndex.state = 2;
                            _GCompetencesIndex.type = 1;
                            _result.Add(_GCompetencesIndex);
                        }

                        _course = BLP.BLELearning.Course.Restore(_loopCompetencePart.CompetenceCourseID);
                        if (_course != null)
                        {
                            // Cwiczenia
                            _currentID++;
                            _GCompetencesIndex = new GCompetencesIndex();
                            _GCompetencesIndex.context_id = _loopCompetencePart.ID.Value;
                            _GCompetencesIndex.course_id = _course.ID.Value;
                            _GCompetencesIndex.id = _currentID;
                            _GCompetencesIndex.name = _course.Title;
                            _GCompetencesIndex.parent_id = _lastCompetencePartID;
                            _GCompetencesIndex.score = null;
                            _GCompetencesIndex.state = 2;
                            _GCompetencesIndex.type = 2;
                            _result.Add(_GCompetencesIndex);
                        }

                        _course = BLP.BLELearning.Course.Restore(_loopCompetencePart.CaseID);
                        if (_course != null)
                        {
                            // Case
                            _currentID++;
                            _GCompetencesIndex = new GCompetencesIndex();
                            _GCompetencesIndex.context_id = _loopCompetencePart.ID.Value;
                            _GCompetencesIndex.course_id = _course.ID.Value;
                            _GCompetencesIndex.id = _currentID;
                            _GCompetencesIndex.name = _course.Title;
                            _GCompetencesIndex.parent_id = _lastCompetencePartID;
                            _GCompetencesIndex.score = null;
                            _GCompetencesIndex.state = 2;
                            _GCompetencesIndex.type = 3;
                            _result.Add(_GCompetencesIndex);
                        }
                    }
                }
                #endregion

                #region End course
                if (_endKnowledgeTestCourseID.HasValue)
                {
                    _currentID++;
                    GM.N610.ELearning.BL.BO.Course _course = BLP.BLELearning.Course.Restore(_endKnowledgeTestCourseID);
                    GCompetencesIndex _GCompetencesIndex = new GCompetencesIndex();
                    _GCompetencesIndex.id = _currentID;
                    _GCompetencesIndex.context_id = BL.Dictionary.Config.Tests.EndKnowledgeTest.ContextObjectID;
                    _GCompetencesIndex.course_id = _course.ID.Value;
                    _GCompetencesIndex.name = _course.Title;
                    _GCompetencesIndex.parent_id = 0;
                    _GCompetencesIndex.score = null;
                    _GCompetencesIndex.state = 2;
                    _GCompetencesIndex.type = 4;
                    _result.Add(_GCompetencesIndex);
                }
                if (_endAdvancedTestCourseID.HasValue)
                {
                    _currentID++;
                    GM.N610.ELearning.BL.BO.Course _course = BLP.BLELearning.Course.Restore(_endAdvancedTestCourseID);
                    GCompetencesIndex _GCompetencesIndex = new GCompetencesIndex();
                    _GCompetencesIndex.id = _currentID;
                    _GCompetencesIndex.context_id = BL.Dictionary.Config.Tests.EndAdvancedTest.ContextObjectID;
                    _GCompetencesIndex.course_id = _course.ID.Value;
                    _GCompetencesIndex.name = _course.Title;
                    _GCompetencesIndex.parent_id = 0;
                    _GCompetencesIndex.score = null;
                    _GCompetencesIndex.state = 2;
                    _GCompetencesIndex.type = 4;
                    _result.Add(_GCompetencesIndex);
                }
                #endregion

                return _result;
            }

            public GResponseData LoadExercise(BL.ZSBELearning.ContextParam ContextParam, XslCompiledTransform XslCompiledTransform)
            {
                GResponseData _GResponseData = null;
                if (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None)
                {
                    if (ContextParam.ExerciseOut != null)
                    {
                        switch (ContextParam.ExerciseOut.Type)
                        {
                            #region GExerciseData_UzupelnianieLukI
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Section:
                                GExerciseData_UzupelnianieLukI _MovingBox_Section = new GExerciseData_UzupelnianieLukI(BLP, ContextParam);
                                _MovingBox_Section.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukI.ExerciseDataStub>() { ExerciseData = _MovingBox_Section.ExerciseData, Exercise = _MovingBox_Section.Exercise, ExerciseMeta = _MovingBox_Section.ExerciseMeta, ExerciseNote = _MovingBox_Section.ExerciseNote, ExerciseOwl = _MovingBox_Section.ExerciseOwl };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Text:
                                GExerciseData_UzupelnianieLukI _MovingBox_Text = new GExerciseData_UzupelnianieLukI(BLP, ContextParam);
                                _MovingBox_Text.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukI.ExerciseDataStub>() { ExerciseData = _MovingBox_Text.ExerciseData, Exercise = _MovingBox_Text.Exercise, ExerciseMeta = _MovingBox_Text.ExerciseMeta, ExerciseNote = _MovingBox_Text.ExerciseNote, ExerciseOwl = _MovingBox_Text.ExerciseOwl };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_MovingBox:
                                GExerciseData_UzupelnianieLukI _Questions_MovingBox = new GExerciseData_UzupelnianieLukI(BLP, ContextParam);
                                _Questions_MovingBox.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukI.ExerciseDataStub>() { ExerciseData = _Questions_MovingBox.ExerciseData, Exercise = _Questions_MovingBox.Exercise, ExerciseMeta = _Questions_MovingBox.ExerciseMeta, ExerciseNote = _Questions_MovingBox.ExerciseNote, ExerciseOwl = _Questions_MovingBox.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_UzupelnianieLukII
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Section:
                                GExerciseData_UzupelnianieLukII _ComboBox_Section = new GExerciseData_UzupelnianieLukII(BLP, ContextParam);
                                _ComboBox_Section.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukII.ExerciseDataStub>() { ExerciseData = _ComboBox_Section.ExerciseData, Exercise = _ComboBox_Section.Exercise, ExerciseMeta = _ComboBox_Section.ExerciseMeta, ExerciseNote = _ComboBox_Section.ExerciseNote, ExerciseOwl = _ComboBox_Section.ExerciseOwl };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Text:
                                GExerciseData_UzupelnianieLukII _ComboBox_Text = new GExerciseData_UzupelnianieLukII(BLP, ContextParam);
                                _ComboBox_Text.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukII.ExerciseDataStub>() { ExerciseData = _ComboBox_Text.ExerciseData, Exercise = _ComboBox_Text.Exercise, ExerciseMeta = _ComboBox_Text.ExerciseMeta, ExerciseNote = _ComboBox_Text.ExerciseNote, ExerciseOwl = _ComboBox_Text.ExerciseOwl };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ComboBox:
                                GExerciseData_UzupelnianieLukII _Questions_ComboBox = new GExerciseData_UzupelnianieLukII(BLP, ContextParam);
                                _Questions_ComboBox.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukII.ExerciseDataStub>() { ExerciseData = _Questions_ComboBox.ExerciseData, Exercise = _Questions_ComboBox.Exercise, ExerciseMeta = _Questions_ComboBox.ExerciseMeta, ExerciseNote = _Questions_ComboBox.ExerciseNote, ExerciseOwl = _Questions_ComboBox.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_UzupelnianieLukIII
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Section:
                                GExerciseData_UzupelnianieLukIII _OpenGap_Section = new GExerciseData_UzupelnianieLukIII(BLP, ContextParam);
                                _OpenGap_Section.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukIII.ExerciseDataStub>() { ExerciseData = _OpenGap_Section.ExerciseData, Exercise = _OpenGap_Section.Exercise, ExerciseMeta = _OpenGap_Section.ExerciseMeta, ExerciseNote = _OpenGap_Section.ExerciseNote, ExerciseOwl = _OpenGap_Section.ExerciseOwl };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Text:
                                GExerciseData_UzupelnianieLukIII _OpenGap_Text = new GExerciseData_UzupelnianieLukIII(BLP, ContextParam);
                                _OpenGap_Text.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukIII.ExerciseDataStub>() { ExerciseData = _OpenGap_Text.ExerciseData, Exercise = _OpenGap_Text.Exercise, ExerciseMeta = _OpenGap_Text.ExerciseMeta, ExerciseNote = _OpenGap_Text.ExerciseNote, ExerciseOwl = _OpenGap_Text.ExerciseOwl };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_OpenGap:
                                GExerciseData_UzupelnianieLukIII _Questions_OpenGap = new GExerciseData_UzupelnianieLukIII(BLP, ContextParam);
                                _Questions_OpenGap.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_UzupelnianieLukIII.ExerciseDataStub>() { ExerciseData = _Questions_OpenGap.ExerciseData, Exercise = _Questions_OpenGap.Exercise, ExerciseMeta = _Questions_OpenGap.ExerciseMeta, ExerciseNote = _Questions_OpenGap.ExerciseNote, ExerciseOwl = _Questions_OpenGap.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_LaczenieKolumn
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Matching:
                                GExerciseData_LaczenieKolumn _Matching = new GExerciseData_LaczenieKolumn(BLP, ContextParam);
                                _Matching.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_LaczenieKolumn.ExerciseDataStub>() { ExerciseData = _Matching.ExerciseData, Exercise = _Matching.Exercise, ExerciseMeta = _Matching.ExerciseMeta, ExerciseNote = _Matching.ExerciseNote, ExerciseOwl = _Matching.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_Klasyfikacja
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Areas:
                                GExerciseData_Klasyfikacja _MovingBox_Areas = new GExerciseData_Klasyfikacja(BLP, ContextParam);
                                _MovingBox_Areas.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_Klasyfikacja.ExerciseDataStub>() { ExerciseData = _MovingBox_Areas.ExerciseData, Exercise = _MovingBox_Areas.Exercise, ExerciseMeta = _MovingBox_Areas.ExerciseMeta, ExerciseNote = _MovingBox_Areas.ExerciseNote, ExerciseOwl = _MovingBox_Areas.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_PytaniezObrazkiem
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Points:
                                GExerciseData_PytaniezObrazkiem _MovingBox_Points = new GExerciseData_PytaniezObrazkiem(BLP, ContextParam);
                                _MovingBox_Points.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_PytaniezObrazkiem.ExerciseDataStub>() { ExerciseData = _MovingBox_Points.ExerciseData, Exercise = _MovingBox_Points.Exercise, ExerciseMeta = _MovingBox_Points.ExerciseMeta, ExerciseNote = _MovingBox_Points.ExerciseNote, ExerciseOwl = _MovingBox_Points.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_Slajd
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Text:
                                GExerciseData_Slajd _Text = new GExerciseData_Slajd(BLP, ContextParam);
                                _Text.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_Slajd.ExerciseDataStub>() { ExerciseData = _Text.ExerciseData, Exercise = _Text.Exercise, ExerciseMeta = _Text.ExerciseMeta, ExerciseNote = _Text.ExerciseNote, ExerciseOwl = _Text.ExerciseOwl };
                                break;
                            #endregion

                            #region GExerciseData_PytaniezObrazkiem
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ABCD:
                                GExerciseData_OpcjeWyboru _Questions_ABCD = new GExerciseData_OpcjeWyboru(BLP, ContextParam);
                                _Questions_ABCD.Load();
                                _GResponseData = new GResponseData_Exercise<GExerciseData_OpcjeWyboru.ExerciseDataStub>() { ExerciseData = _Questions_ABCD.ExerciseData, Exercise = _Questions_ABCD.Exercise, ExerciseMeta = _Questions_ABCD.ExerciseMeta, ExerciseNote = _Questions_ABCD.ExerciseNote, ExerciseOwl = _Questions_ABCD.ExerciseOwl };
                                break;
                            #endregion
                        }
                    }
                }
                else
                {
                    switch (ContextParam.AuxyliaryPages)
                    {
                        case Dictionary.AuxyliaryPagesType.CourseMenu:
                            GExerciseData_CourseMenu _CourseMenu = new GExerciseData_CourseMenu(BLP, ContextParam);
                            _CourseMenu.Load();
                            _GResponseData = new GResponseData_Exercise<GExerciseData_CourseMenu.ExerciseDataStub>() { ExerciseData = _CourseMenu.ExerciseData, Exercise = _CourseMenu.Exercise, ExerciseMeta = _CourseMenu.ExerciseMeta };
                            break;

                        default:
                            GExerciseData_Auxyliary _Auxyliary = new GExerciseData_Auxyliary(BLP, ContextParam, XslCompiledTransform);
                            _Auxyliary.Load();
                            _GResponseData = new GResponseData_Exercise<GExerciseData_Auxyliary.ExerciseDataStub>() { ExerciseData = _Auxyliary.ExerciseData, Exercise = _Auxyliary.Exercise, ExerciseMeta = _Auxyliary.ExerciseMeta };
                            break;
                    }
                }

                return _GResponseData;
            }

            public GResponseData CheckExercise(ContextParam ContextParam, XslCompiledTransform XslCompiledTransform, List<GExerciseDataCheckOne> ListExerciseDataSave)
            {
                GResponseData _GResponseData = null;
                if (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None)
                {
                    if (ContextParam.ExerciseIn != null)
                    {
                        switch (ContextParam.ExerciseIn.Type)
                        {
                            #region GExerciseData_UzupelnianieLukI
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Section:
                                GExerciseData_UzupelnianieLukI _MovingBox_Section = new GExerciseData_UzupelnianieLukI(BLP, ContextParam);
                                _MovingBox_Section.Load();
                                _MovingBox_Section.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukI.ExerciseDataStub>() { ExerciseData = _MovingBox_Section.ExerciseData, ExerciseMeta = _MovingBox_Section.ExerciseMeta, ExerciseOwl = _MovingBox_Section.ExerciseOwlSave, ExerciseCheck = _MovingBox_Section.ExerciseCheck };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Text:
                                GExerciseData_UzupelnianieLukI _MovingBox_Text = new GExerciseData_UzupelnianieLukI(BLP, ContextParam);
                                _MovingBox_Text.Load();
                                _MovingBox_Text.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukI.ExerciseDataStub>() { ExerciseData = _MovingBox_Text.ExerciseData, ExerciseMeta = _MovingBox_Text.ExerciseMeta, ExerciseOwl = _MovingBox_Text.ExerciseOwlSave, ExerciseCheck = _MovingBox_Text.ExerciseCheck };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_MovingBox:
                                GExerciseData_UzupelnianieLukI _Questions_MovingBox = new GExerciseData_UzupelnianieLukI(BLP, ContextParam);
                                _Questions_MovingBox.Load();
                                _Questions_MovingBox.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukI.ExerciseDataStub>() { ExerciseData = _Questions_MovingBox.ExerciseData, ExerciseMeta = _Questions_MovingBox.ExerciseMeta, ExerciseOwl = _Questions_MovingBox.ExerciseOwlSave, ExerciseCheck = _Questions_MovingBox.ExerciseCheck };
                                break;
                            #endregion

                            #region GExerciseData_UzupelnianieLukII
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Section:
                                GExerciseData_UzupelnianieLukII _ComboBox_Section = new GExerciseData_UzupelnianieLukII(BLP, ContextParam);
                                _ComboBox_Section.Load();
                                _ComboBox_Section.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukII.ExerciseDataStub>() { ExerciseData = _ComboBox_Section.ExerciseData, ExerciseMeta = _ComboBox_Section.ExerciseMeta, ExerciseOwl = _ComboBox_Section.ExerciseOwlSave, ExerciseCheck = _ComboBox_Section.ExerciseCheck };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Text:
                                GExerciseData_UzupelnianieLukII _ComboBox_Text = new GExerciseData_UzupelnianieLukII(BLP, ContextParam);
                                _ComboBox_Text.Load();
                                _ComboBox_Text.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukII.ExerciseDataStub>() { ExerciseData = _ComboBox_Text.ExerciseData, ExerciseMeta = _ComboBox_Text.ExerciseMeta, ExerciseOwl = _ComboBox_Text.ExerciseOwlSave, ExerciseCheck = _ComboBox_Text.ExerciseCheck };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ComboBox:
                                GExerciseData_UzupelnianieLukII _Questions_ComboBox = new GExerciseData_UzupelnianieLukII(BLP, ContextParam);
                                _Questions_ComboBox.Load();
                                _Questions_ComboBox.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukII.ExerciseDataStub>() { ExerciseData = _Questions_ComboBox.ExerciseData, ExerciseMeta = _Questions_ComboBox.ExerciseMeta, ExerciseOwl = _Questions_ComboBox.ExerciseOwlSave, ExerciseCheck = _Questions_ComboBox.ExerciseCheck };
                                break;
                            #endregion

                            #region GExerciseData_UzupelnianieLukIII
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Section:
                                GExerciseData_UzupelnianieLukIII _OpenGap_Section = new GExerciseData_UzupelnianieLukIII(BLP, ContextParam);
                                _OpenGap_Section.Load();
                                _OpenGap_Section.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukIII.ExerciseDataStub>() { ExerciseData = _OpenGap_Section.ExerciseData, ExerciseMeta = _OpenGap_Section.ExerciseMeta, ExerciseOwl = _OpenGap_Section.ExerciseOwlSave, ExerciseCheck = _OpenGap_Section.ExerciseCheck };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.OpenGap_Text:
                                GExerciseData_UzupelnianieLukIII _OpenGap_Text = new GExerciseData_UzupelnianieLukIII(BLP, ContextParam);
                                _OpenGap_Text.Load();
                                _OpenGap_Text.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukIII.ExerciseDataStub>() { ExerciseData = _OpenGap_Text.ExerciseData, ExerciseMeta = _OpenGap_Text.ExerciseMeta, ExerciseOwl = _OpenGap_Text.ExerciseOwlSave, ExerciseCheck = _OpenGap_Text.ExerciseCheck };
                                break;
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_OpenGap:
                                GExerciseData_UzupelnianieLukIII _Questions_OpenGap = new GExerciseData_UzupelnianieLukIII(BLP, ContextParam);
                                _Questions_OpenGap.Load();
                                _Questions_OpenGap.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_UzupelnianieLukIII.ExerciseDataStub>() { ExerciseData = _Questions_OpenGap.ExerciseData, ExerciseMeta = _Questions_OpenGap.ExerciseMeta, ExerciseOwl = _Questions_OpenGap.ExerciseOwlSave, ExerciseCheck = _Questions_OpenGap.ExerciseCheck };
                                break;
                            #endregion

                            #region GExerciseData_LaczenieKolumn
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Matching:
                                GExerciseData_LaczenieKolumn _Matching = new GExerciseData_LaczenieKolumn(BLP, ContextParam);
                                _Matching.Load();
                                _Matching.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_LaczenieKolumn.ExerciseDataStub>() { ExerciseData = _Matching.ExerciseData, ExerciseMeta = _Matching.ExerciseMeta, ExerciseOwl = _Matching.ExerciseOwlSave, ExerciseCheck = _Matching.ExerciseCheck };
                                break;
                            #endregion

                            #region GExerciseData_Klasyfikacja
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Areas:
                                GExerciseData_Klasyfikacja _MovingBox_Areas = new GExerciseData_Klasyfikacja(BLP, ContextParam);
                                _MovingBox_Areas.Load();
                                _MovingBox_Areas.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_Klasyfikacja.ExerciseDataStub>() { ExerciseData = _MovingBox_Areas.ExerciseData, ExerciseMeta = _MovingBox_Areas.ExerciseMeta, ExerciseOwl = _MovingBox_Areas.ExerciseOwlSave, ExerciseCheck = _MovingBox_Areas.ExerciseCheck };
                                break;
                            #endregion

                            #region GExerciseData_PytaniezObrazkiem
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Points:
                                GExerciseData_PytaniezObrazkiem _MovingBox_Points = new GExerciseData_PytaniezObrazkiem(BLP, ContextParam);
                                _MovingBox_Points.Load();
                                _MovingBox_Points.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_PytaniezObrazkiem.ExerciseDataStub>() { ExerciseData = _MovingBox_Points.ExerciseData, ExerciseMeta = _MovingBox_Points.ExerciseMeta, ExerciseOwl = _MovingBox_Points.ExerciseOwlSave, ExerciseCheck = _MovingBox_Points.ExerciseCheck };
                                break;
                            #endregion

                            #region GExerciseData_PytaniezObrazkiem
                            case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ABCD:
                                GExerciseData_OpcjeWyboru _Questions_ABCD = new GExerciseData_OpcjeWyboru(BLP, ContextParam);
                                _Questions_ABCD.Load();
                                _Questions_ABCD.Check(ListExerciseDataSave);
                                _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_OpcjeWyboru.ExerciseDataStub>() { ExerciseData = _Questions_ABCD.ExerciseData, ExerciseMeta = _Questions_ABCD.ExerciseMeta, ExerciseOwl = _Questions_ABCD.ExerciseOwlSave, ExerciseCheck = _Questions_ABCD.ExerciseCheck };
                                break;
                            #endregion
                        }
                    }
                }
                else
                {
                    switch (ContextParam.AuxyliaryPages)
                    {
                        case Dictionary.AuxyliaryPagesType.CourseMenu:
                            GExerciseData_CourseMenu _CourseMenu = new GExerciseData_CourseMenu(BLP, ContextParam);
                            _CourseMenu.Check(ListExerciseDataSave);
                            _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_CourseMenu.ExerciseDataStub>() { ExerciseData = _CourseMenu.ExerciseData, ExerciseMeta = _CourseMenu.ExerciseMeta };
                            break;

                        default:
                            GExerciseData_Auxyliary _Auxyliary = new GExerciseData_Auxyliary(BLP, ContextParam, XslCompiledTransform);
                            _Auxyliary.Check(ListExerciseDataSave);
                            _GResponseData = new GResponseData_ExerciseCheck<GExerciseData_Auxyliary.ExerciseDataStub>() { ExerciseData = _Auxyliary.ExerciseData, ExerciseMeta = _Auxyliary.ExerciseMeta };
                            break;
                    }
                }

                return _GResponseData;
            }

            /// <summary>
            /// Metoda generuje liste statystyk dla ucznia
            /// </summary>
            /// <param name="User"></param>
            /// <returns></returns>
            public List<GStatsValue> GetStatsData(FM.N001.Account.BL.BO.View.User User)
            {

                if (User != null)
                {
                    BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                    if (_group == Dictionary.GroupType.Student)
                    {
                        PI.ZB.N1200.ELearning.BL.BO.Student _student = BLP.Student.RestoreByUser(User);
                        if (_student != null)
                        {
                            List<GStatsValue> _result = new List<GStatsValue>();
                            PI.ZB.N1200.ELearning.BL.BO.Class _class = BLP.Class.Restore(_student);
                            BL.BO.View.StatisticStudent _classStatisticStudent = BLP.Statistic.StudentStatistic.Restore(_class)[0];

                            //Aktualne stanowisko
                            _result.Add(new GStatsValue() { Label = "Aktualne stanowisko", User = BLP.EvaluationSheet.Restore().Where(x => x.ID == _student.CurrentEvaluationSheetID).FirstOrDefault().Name, Group = string.Empty });

                            //Aktualny poziom zaawansowania
                            _result.Add(new GStatsValue() { Label = "Aktualny poziom zaawansowania", User = BLP.AdvancedLevel.Restore().Where(x => x.ID == _student.CurrentAdvancedLevelID).FirstOrDefault().Name, Group = string.Empty });

                            //Pensja
                            _result.Add(new GStatsValue() { Label = "Pensja", User = _student.SalaryValue.ToString(), Group = _classStatisticStudent.SalaryAvg.ToString() });

                            //Wynik z inwestycji w eduFarma
                            _result.Add(new GStatsValue() { Label = "Wynik z inwestycji w eduFarma", User = _student.GameCashValue.ToString(), Group = _classStatisticStudent.GameCashAvg.ToString() });

                            //Średni wynik z ćwiczeń
                            _result.Add(new GStatsValue() { Label = "Średni wynik z ćwiczeń", User = string.Format("{0} %", _student.CompetencePointsPercent), Group = string.Format("{0} %", _classStatisticStudent.CompetencePointsPercent) });

                            //Średni wynik z praktyki
                            _result.Add(new GStatsValue() { Label = "Średni wynik z praktyki", User = string.Format("{0} %", _student.CaseStudyPointsPercent), Group = string.Format("{0} %", _classStatisticStudent.CaseStudyPointsPercent) });

                            //Średnia ilość powtórzeń
                            _result.Add(new GStatsValue() { Label = "Średnia ilość powtórzeń", User = string.Format("{0}", Math.Round(_student.CompetencePartDoneAvg,2)), Group = string.Format("{0}", Math.Round(_classStatisticStudent.CompetencePartDoneAvg,2)) });

                            //Test wiedzy początkowy
                            _result.Add(new GStatsValue() { Label = "Test wiedzy początkowy", User = string.Format("{0} %", _student.KnowledgeTestStartPointsPercent), Group = string.Format("{0} %", _classStatisticStudent.KnowledgeTestStartPointsPercent) });

                            //Test wiedzy końcowy
                            _result.Add(new GStatsValue() { Label = "Test wiedzy końcowy", User = string.Format("{0} %", _student.KnowledgeTestEndPointsPercent), Group = string.Format("{0} %", _classStatisticStudent.KnowledgeTestEndPointsPercent) });

                            //Test umiejętności początkowy
                            _result.Add(new GStatsValue() { Label = "Test umiejętności początkowy", User = string.Format("{0} %", _student.AdvancedTestStartPointsPercent), Group = string.Format("{0} %", _classStatisticStudent.AdvancedTestStartPointsPercent) });

                            //Test umiejętności końcowy
                            _result.Add(new GStatsValue() { Label = "Test umiejętności końcowy", User = string.Format("{0} %", _student.AdvancedTestEndPointsPercent), Group = string.Format("{0} %", _classStatisticStudent.AdvancedTestEndPointsPercent) });

                            List<BL.BO.View.StatisticAdvancedLevel> _stopnieTrudnosciDlaKlasy = BLP.Statistic.AdvancedLevel.RestoreByClassID(_classStatisticStudent.ClassID);
                            List<BL.BO.View.StatisticAdvancedLevel> _stopnieTrudnosciDlaStudenta = BLP.Statistic.AdvancedLevel.Restore(_student);

                            int _sumClass = _stopnieTrudnosciDlaKlasy.Sum(x => (x.Count ?? 0));
                            int _sumStudent = _stopnieTrudnosciDlaStudenta.Sum(x => (x.Count ?? 0));

                            //Poziomy zaawansowania
                            foreach (BL.BO.View.StatisticAdvancedLevel _loopStatisticAdvancedLevel in _stopnieTrudnosciDlaKlasy)
                            {
                                _result.Add(new GStatsValue() { Label = _loopStatisticAdvancedLevel.Name, User = string.Format("{0} %", BL.BasicUtility.PointPercent(_stopnieTrudnosciDlaStudenta.Where(x => x.Name == _loopStatisticAdvancedLevel.Name).FirstOrDefault().Count, _sumStudent)), Group = string.Format("{0} %", BL.BasicUtility.PointPercent(_loopStatisticAdvancedLevel.Count, _sumClass)) });
                            }


                            return _result;
                        }
                    }
                }
                return null;
            }

            /// <summary>
            /// Lita certyfikatów dla ucznia - odpowiedz dla metody certificatesindex
            /// </summary>
            /// <param name="User"></param>
            /// <param name="DomainURL"></param>
            /// <returns></returns>
            public List<GCertificate> GetCertificates(FM.N001.Account.BL.BO.View.User User, string DomainURL)
            {
                if (User != null)
                {
                    BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                    if (_group == Dictionary.GroupType.Student)
                    {
                        PI.ZB.N1200.ELearning.BL.BO.Student _student = BLP.Student.RestoreByUser(User);
                        if (_student != null)
                        {
                            List<GCertificate> _result = new List<GCertificate>();
                            foreach (BL.BO.StudentDoc _loopStudentDoc in BLP.StudentDoc.Restore(_student))
                            {
                                _result.Add(new GCertificate() { id = _loopStudentDoc.ID.Value, name = _loopStudentDoc.Name, pdf = string.Format("{0}{1}", DomainURL, _loopStudentDoc.Path), url = string.Format("{0}{1}", DomainURL, _loopStudentDoc.Path.Replace(".pdf", ".jpg")) });
                            }
                            return _result;
                        }
                    }

                }
                return null;
            }

            public GRankingData GetRankingData(FM.N001.Account.BL.BO.View.User User, int RankingID)
            {
                BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                if (_group == Dictionary.GroupType.Student)
                {
                    PI.ZB.N1200.ELearning.BL.BO.Student _student = BLP.Student.RestoreByUser(User);
                    if (_student != null)
                    {
                        GRankingData _result = new GRankingData();
                        GRankingGroupValues _groupValues = null;
                        BL.BO.Student.Search _search = null;
                        List<BL.BO.Student> _studentList = null;
                        switch (RankingID)
                        {
                            case 1:
                                _search = new BO.Student.Search();
                                _search.ClassID = _student.ClassID;
                                _search.SortOrder = BL.BO.Student.Search.SortOrderType.SalarySurnameName;

                                _result.Name = "Ranking zgromadzonych środków";
                                _result.Headers.AddRange(new string[] { "Uczeń", "Stanowisko", "Pensja" });

                                _studentList = BLP.Student.Restore(_search);
                                _groupValues = new GRankingGroupValues();
                                _groupValues.Name = string.Empty;
                                foreach (BL.BO.Student _loopStudent in _studentList)
                                {
                                    List<string> _values = new List<string>();
                                    _values.AddRange(new string[] { _loopStudent.DisplayValue, GetEvaluationName(_loopStudent.CurrentEvaluationSheetID), _loopStudent.SalaryValue.ToString() });
                                    _groupValues.Values.Add(_values);
                                }
                                _result.Groups.Add(_groupValues);
                                break;
                            case 2:
                                _search = new BO.Student.Search();
                                _search.ClassID = _student.ClassID;
                                _search.SortOrder = BL.BO.Student.Search.SortOrderType.GameCashSurnameName;

                                _result.Name = "Ranking eduFarma";
                                _result.Headers.AddRange(new string[] { "Uczeń", "Stanowisko", "Środki z eduFarma" });

                                _studentList = BLP.Student.Restore(_search);
                                _groupValues = new GRankingGroupValues();
                                _groupValues.Name = string.Empty;
                                foreach (BL.BO.Student _loopStudent in _studentList)
                                {
                                    List<string> _values = new List<string>();
                                    _values.AddRange(new string[] { _loopStudent.DisplayValue, GetEvaluationName(_loopStudent.CurrentEvaluationSheetID), _loopStudent.GameCashValue.ToString() });
                                    _groupValues.Values.Add(_values);
                                }
                                _result.Groups.Add(_groupValues);
                                break;
                            case 3:
                                _search = new BO.Student.Search();
                                _search.ClassID = _student.ClassID;
                                _search.SortOrder = BL.BO.Student.Search.SortOrderType.CurrentAdvancedLevelIDSurnameName;

                                _result.Name = "Ranking zajmowanych stanowisk";
                                _result.Headers.AddRange(new string[] { "Uczeń", "Pensja", "Środki z eduFarma" });

                                _studentList = BLP.Student.Restore(_search);
                                _groupValues = new GRankingGroupValues();
                                _groupValues.Name = string.Empty;

                                List<BO.EvaluationSheet> _list = BLP.EvaluationSheet.Restore();
                                _list.Reverse();
                                foreach (BO.EvaluationSheet _loopEvaluationSheet in _list)
                                {
                                    _groupValues = new GRankingGroupValues();
                                    _groupValues.Name = _loopEvaluationSheet.Name;
                                    foreach (BL.BO.Student _loopStudent in _studentList.Where(x => x.CurrentEvaluationSheetID == _loopEvaluationSheet.ID).ToList())
                                    {
                                        List<string> _values = new List<string>();
                                        _values.AddRange(new string[] { _loopStudent.DisplayValue, _loopStudent.SalaryValue.ToString(), _loopStudent.GameCashValue.ToString() });
                                        _groupValues.Values.Add(_values);
                                    }
                                    _result.Groups.Add(_groupValues);
                                }
                                break;
                        }

                        return _result;
                    }
                }
                return null;
            }

            private Dictionary<long?, string> _evaluationNames = new Dictionary<long?, string>();
            private string GetEvaluationName(long? EvaluationSheetID)
            {
                if (EvaluationSheetID.HasValue)
                {
                    if (!_evaluationNames.ContainsKey(EvaluationSheetID))
                    {
                        _evaluationNames.Add(EvaluationSheetID, BLP.EvaluationSheet.Cache.RestoreName(EvaluationSheetID));
                    }
                    return _evaluationNames[EvaluationSheetID];
                }
                return string.Empty;
            }

            public GStatsCompetenceView GetStatsCompetenceView(FM.N001.Account.BL.BO.View.User User, long CompetenceID)
            {
                BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                if (_group == Dictionary.GroupType.Student)
                {
                    PI.ZB.N1200.ELearning.BL.BO.Student _student = BLP.Student.RestoreByUser(User);
                    if (_student != null)
                    {
                        BO.Competence _competence = null;
                        GStatsCompetenceView _result = new GStatsCompetenceView();
                        List<BO.AdvancedLevel> _listAdvancedLevel = BLP.AdvancedLevel.Restore();
                        if (CompetenceID > 0)
                        {
                            _competence = BLP.Competence.Restore(CompetenceID);
                            if (_competence != null)
                            {
                                _result.Name = string.Format("Statystyka kompetencji składowych dla {0}", _competence.Name);
                                _result.Headers.AddRange(new string[] { "Nazwa kompetencji składowej", "Wynik z ćwiczeń", "Wynik z praktyki", "Ilość powtórzeń", "Pensja", "Poziom trudności" });
                            }
                        }
                        else
                        {
                            _result.Name = "Statystyka kompetencji głównych";
                            _result.Headers.AddRange(new string[] { "Nazwa kompetencji", "Średni wynik z ćwiczeń", "Średni wynik z praktyki", "Średnia ilość powtórzeń" });
                            foreach (BO.AdvancedLevel _loopAdvancedLevel in _listAdvancedLevel)
                            {
                                _result.Headers.Add(_loopAdvancedLevel.Name);
                            }
                        }

                        if (_result.Headers.Count > 0)
                        {

                            if (_competence == null)
                            {
                                foreach (BL.BO.View.StatisticCompetence _loopStatisticCompetence in BLP.Statistic.CompetenceStatistic.Restore(_student))
                                {
                                    GStatsCompetenceViewRow _row = new GStatsCompetenceViewRow();
                                    _row.DetailURI = "competence_id=" + _loopStatisticCompetence.ID;
                                    _row.Values.Add(string.IsNullOrEmpty(_loopStatisticCompetence.Abbreviation) ? _loopStatisticCompetence.Name : _loopStatisticCompetence.Abbreviation);
                                    _row.Values.Add(string.Format("{0} %", _loopStatisticCompetence.CompetencePointsPercent));
                                    _row.Values.Add(string.Format("{0} %", _loopStatisticCompetence.CaseStudyPointsPercent));
                                    _row.Values.Add(string.Format("{0}", Math.Round(_loopStatisticCompetence.CompetencePartDoneAvg,2)));

                                    List<BL.BO.View.StatisticAdvancedLevel> _listStatisticAdvancedLevel = BLP.Statistic.AdvancedLevel.Restore(_student, _loopStatisticCompetence.ID);
                                    int _sum = _listStatisticAdvancedLevel.Sum(x => (x.Count ?? 0));
                                    foreach (BL.BO.View.StatisticAdvancedLevel _loopStatisticAdvancedLevel in _listStatisticAdvancedLevel)
                                    {
                                        _row.Values.Add(string.Format("{0} %", BL.BasicUtility.PointPercent(_loopStatisticAdvancedLevel.Count, _sum)));
                                    }

                                    _result.Rows.Add(_row);
                                }
                            }
                            else
                            {
                                foreach (BL.BO.View.StatisticCompetencePart _loopStatisticCompetencePart in BLP.Statistic.CompetencePartStatistic.Restore(_student, _competence.ID))
                                {
                                    GStatsCompetenceViewRow _row = new GStatsCompetenceViewRow();

                                    List<BL.BO.View.StatisticAdvancedLevel> _listStatisticAdvancedLevel = BLP.Statistic.AdvancedLevel.Restore(_student, _loopStatisticCompetencePart.CompetenceID, _loopStatisticCompetencePart.ID);
                                    int _sum = _listStatisticAdvancedLevel.Sum(x => (x.Count ?? 0));

                                    BL.BO.View.StatisticAdvancedLevel _StatisticAdvancedLevel = _listStatisticAdvancedLevel.Where(x => (BL.BasicUtility.PointPercent(x.Count, _sum) > 0)).FirstOrDefault();

                                    _row.Values.Add(string.IsNullOrEmpty(_loopStatisticCompetencePart.Abbreviation) ? _loopStatisticCompetencePart.Name : _loopStatisticCompetencePart.Abbreviation);
                                    _row.Values.Add(string.Format("{0} %", _loopStatisticCompetencePart.CompetencePointsPercent));
                                    _row.Values.Add(string.Format("{0} %", _loopStatisticCompetencePart.CaseStudyPointsPercent));
                                    _row.Values.Add(string.Format("{0}", _loopStatisticCompetencePart.ResetCount));
                                    _row.Values.Add(string.Format("{0}", _loopStatisticCompetencePart.SalaryValue));
                                    _row.Values.Add(_StatisticAdvancedLevel != null ? _StatisticAdvancedLevel.Name : string.Empty);
                                    _result.Rows.Add(_row);
                                }
                            }

                            return _result;
                        }
                    }
                }

                return null;
            }

            public GUserProfile GetUserProfile(FM.N001.Account.BL.BO.View.User User, string DomainURL)
            {
                GUserProfile _userProfile = null;
                if (User != null)
                {
                    BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                    if (_group == Dictionary.GroupType.Student)
                    {
                        PI.ZB.N1200.ELearning.BL.BO.Student _student = BLP.Student.RestoreByUser(User);
                        if (_student != null)
                        {
                            _userProfile = new GUserProfile();

                            #region User
                            _userProfile.User.email     = _student.Email;
                            _userProfile.User.name      = _student.Forename;
                            _userProfile.User.surname   = _student.Surename;
                            _userProfile.User.gender    = _student.Sex == true ? "kobieta" : "mężczyzna";
                            _userProfile.User.index_nr  = _student.IndexNr.ToString();
                            #endregion

                            PI.ZB.N1200.ELearning.BL.BO.Class _class = BLP.Class.Restore(_student);
                            
                            if(_class != null)
                            {
                                PI.ZB.N1200.ELearning.BL.BO.SchoolYear _SchoolYear = BLP.SchoolYear.Restore(_class.SchoolYearID);

                                _userProfile.Class.name = _class.Name;
                                _userProfile.Class.name2 = _SchoolYear != null ? _SchoolYear.Name : string.Empty;

                                #region Nauczyciel
                                PI.ZB.N1200.ELearning.BL.BO.Instructor _instructor = BLP.Instructor.Restore(_class);

                                if (_instructor != null)
                                {
                                    _userProfile.Tutor.title = _instructor.Title;
                                    _userProfile.Tutor.name = _instructor.Forename;
                                    _userProfile.Tutor.surname = _instructor.Surename;
                                }
                                #endregion

                                #region Szkoła
                                PI.ZB.N1200.ELearning.BL.BO.School _school = BLP.School.Restore(_class);

                                if (_school != null)
                                {
                                    _userProfile.School.name = _school.Name;
                                    _userProfile.School.address = String.Format("{0} {1}",_school.AddressLine1,_school.AddressLine2);
                                    _userProfile.School.postal = _school.PostCode;
                                    _userProfile.School.city = _school.Town;
                                }
                                #endregion
                            }

                            #region Certyfikat
                            List<GCertificate> _result = new List<GCertificate>();
                            foreach (BL.BO.StudentDoc _loopStudentDoc in BLP.StudentDoc.Restore(_student))
                            {
                                _userProfile.Certificates.Add(new GUserProfile.GCertificates() { id = _loopStudentDoc.ID.Value, name = _loopStudentDoc.Name, pdf = string.Format("{0}{1}", DomainURL, _loopStudentDoc.Path), url = string.Format("{0}{1}", DomainURL, _loopStudentDoc.Path.Replace(".pdf", ".jpg")) });
                            }
                            #endregion
                        }
                    }

                }
                return _userProfile;
            }
        }
    }
}